uniform sampler2D texture0;
uniform vec2 textureSize0;
uniform float brightPassThreshold;

varying vec4 gl_TexCoord[];

void main(void) {
    vec4 vTexCoord = gl_TexCoord[0];

    vec3 luminanceVector = vec3(0.2125, 0.7154, 0.0721);
    vec4 sample = texture2D(texture0, vTexCoord.st);

    float luminance = dot(luminanceVector, sample.rgb);
    luminance =  max(0.0, luminance - brightPassThreshold);
    sample.rgb *= sign(luminance);

    gl_FragColor = sample;
    gl_FragColor.a = 1.0; 
}